# -*- coding: utf-8 -*-

#driven_joint.py
#@author: Olivier Lantsoght
#
#Created on 23/05/2019
#Last update on 23/05/2019
#
#Copyright 2019 Universite Catholique de Louvain


import numpy as np

def user_DrivenJoints(mbs,tsim):
    """ Set the values of the driven joints directly in the mbs structure

    :param mbs: The MbsData structure
    :param tsim: the simulation time
    
    """
    #print("user_DrivenJoints (Template) : This function should not be called")
    
    # Example: joint 5 under constant acceleration with non-zero initial coordinate and velocity
    # mbs.qdd[5] = 2
    # mbs.qd[5]  = mbs.qd0[5] + mbs.qdd[5]*tsim
    # mbs.q[5]   = mbs.qd[5]  + mbs.qd0[5]*tsim + 0.5 * mbs.qdd[5]*tsim*tsim
    
    # Robot trajectory (harmonic motion in x, y, z, of the platform)
    
    f = 0.5
    om = 2 * np.pi * f
    a = 0.2
    
    mbs.q[3] = 0.9 + a * np.sin(om * tsim)
    mbs.qd[3] = a * om * np.cos(om * tsim)
    mbs.qdd[3] = -a * np.power(om,2) * np.sin(om * tsim)
    
    f = 1
    om = 2 * np.pi * f
    a = 0.1
    
    mbs.q[1] = a * np.sin(om * tsim)
    mbs.qd[1] = a * om * np.cos(om * tsim)
    mbs.qdd[1] = -a * np.power(om,2) * np.sin(om * tsim)
    
    mbs.q[2] = a * np.cos(om * tsim)
    mbs.qd[2] = -a * om * np.sin(om * tsim)
    mbs.qdd[2] = -a * np.power(om,2) * np.cos(om * tsim)
    
    return
